import java.io.PrintWriter;

/**
 * BaliLvalueNode is the superclass for all BaliNode's which
 * may be used as assignment target (lvalue).
 */

public interface BaliLvalueNode extends BaliNode {
	/**
	 * Prints the SaM lvalue code (assignment target) for this node
	 * @param out The print writer
	 */
	public abstract void printSamLvalueCode(PrintWriter out);

	/**
	 * Is this a valid Lvalue? 
	 * Check this flag in addition to doing an instanceof check.
	 * @return true if this is a valid lvalue, false otherwise
	 */
	public abstract boolean isValidLvalue();
}
