package edu.cornell.cs.bali.compiler;
/**
 * Used for errors with the compiler
 */
public abstract class IllegalBaliException extends Exception {

        private String message = "Unspecified Error";
        private int line = -1;

        /*  Constructors */
        public IllegalBaliException() {}
        public IllegalBaliException(String msg) { message = msg; }
        public IllegalBaliException(int lc) { line = lc; }
        public IllegalBaliException(String msg, int lc) {
                message = msg;
                line = lc;
        }

        /* Error Retrieval */
        public String getMessage() { return message; }
        public int getLine() { return line; }
        public String toString() 
                { return (line > -1) ? (message + ": line " + line) : message; }
}
