// While Statement Node
import edu.cornell.cs.sam.io.*;
import edu.cornell.cs.bali.compiler.*;
import java.util.*;

public class WhileStat implements ASTNode {
    
    private String name;
    private String bali;
    private ASTNode condition;
    private ASTNode stats;

    public WhileStat(Tokenizer f) throws IllegalBaliException {
	compileWhile(f);
    }

    public void compileWhile(Tokenizer f) throws IllegalBaliException {
	bali = "";
	bali += "while"; 
	bali += f.getOp(); // while (
	condition = new Expr(f);
	bali += condition.toBali();
	bali += f.getOp(); // while ( cond )
	stats = new StatBlock(f);
	bali += stats.toBali();
    }

    public String toSamcode() {
	String sam = "";
	int LC = Program.labelCount;
	sam += "whileloop"+LC+":\n";
 	sam += condition.toSamcode();
	sam += "JUMPC "+"correct" +LC+"\n";
	sam += "JUMP " +"continue"+LC+"\n";
	sam += "correct" +LC+":\n";
	Program.labelCount++; // in case we have more control statements
	sam += stats.toSamcode();
	sam += "JUMP " +"whileloop"+LC+"\n";
	sam += "continue" +LC+":\n";
	return sam;
    }
    
    public String toAST(String tab) {
	return tab + this + "\n" + 
	    condition.toAST(tab+TABBY) + stats.toAST(tab+TABBY);
    }

    public String toBali() {
	return bali;
    }
    
    public String toString() {
	return getClass().getName();
    }
    
}
