// StatBlock Node

import java.util.*;
import edu.cornell.cs.sam.io.*;
import edu.cornell.cs.bali.compiler.*;

public class StatBlock implements ASTNode {
    
    private Vector<ASTNode> statements;
    private String bali;

    public StatBlock(Tokenizer f) throws IllegalBaliException {
	compileStats(f);
    }

    public void compileStats(Tokenizer f) throws IllegalBaliException {
	bali = "";
	bali += f.getOp(); // "{"
	statements = new Vector<ASTNode>(0);
	
	// until reaching end of block ('}'), parse statements: 
	while ( !f.test('}') ) {
	    ASTNode s = new Stat(f);
	    bali += s.toBali();
	    statements.add(s);	
	}
	
	// done processing statement block:
	bali += f.getOp() + "\n"; // '}'
	
    }
	
    public String toSamcode() {
	String s = "";
	for (int i=0; i<statements.size(); i++)
	    s += (statements.get(i)).toSamcode();
	return s;
    }
    
    public String toAST(String tab) {
	String tree = tab + this + "\n";
	for (int i=0; i<statements.size(); i++)
	    tree +=  (statements.get(i)).toAST(tab+TABBY);
	return tree;
    }
    
    public String toBali() {
	return bali;
    }

    
    public String toString() {
	return getClass().getName();
    }
    
}
