// Statement Node
import edu.cornell.cs.sam.io.*;
import edu.cornell.cs.bali.compiler.*;
import java.util.*;

public class Stat implements ASTNode {
    
    private String name;
    private String bali;
    private ASTNode stat;

    public Stat(Tokenizer f) throws IllegalBaliException {
	bali = "";
	compileStat(f);
    }

    public void compileStat(Tokenizer f) throws IllegalBaliException {
	String w = f.getWord(); // eat 1st of word of statement
	if (w.equals("if"))
	    stat = new IfStat(f);
	else if (w.equals("while"))
	    stat = new WhileStat(f);
	else
	    stat = new AssignStat(w,f);
    }

    public String toSamcode() {
	return stat.toSamcode();
    }
    
    public String toAST(String tab) {
	return tab + this + "\n" + stat.toAST(tab+TABBY);
    }

    public String toBali() {
	return bali + stat.toBali();
    }
    
    public String toString() {
	return getClass().getName();
    }
    
}
