// Program Node
import edu.cornell.cs.sam.io.*;
import edu.cornell.cs.bali.compiler.*;

public class Program implements ASTNode {

    private ASTNode mainFunction;
    public static int labelCount; // for control structure jump labels

    public Program(Tokenizer f) throws IllegalBaliException {
	mainFunction = new Main(f);
    }

    public String toSamcode() {
	return "//--Program--\n" + mainFunction.toSamcode() + "STOP\n";
    }
    
    public String toAST(String tab) {
	return "\n" + tab + this + "\n" + 
	    mainFunction.toAST(tab+TABBY);
    }

    public String toBali() {
	return "" + mainFunction.toBali();
    }
    
    public String toString() {
	return getClass().getName();
    }
    
}
