// Integer Expressions

import edu.cornell.cs.sam.io.*;
import edu.cornell.cs.bali.compiler.*;

public class NameExpr implements ASTNode {
    
    private String name;
    private String bali;
    private int offset;

    public NameExpr(String name, Tokenizer f) throws IllegalBaliException {
	bali = "";
	this.name = name;
	offset = ( (Integer) (DeclBlock.getSymbolTable().get(name)) ).intValue();
	bali += name;
    }

    // Generate code:
    public String toSamcode() {
        return "PUSHOFF "+offset+"\n";
    }
    
    public String toAST(String tab) {
	return tab + this + "\n";
    }

    public String toBali() {
	return bali;
    }
    
    public String toString() {
	return getClass().getName();
    }
    
}
