// Main Function Node
import edu.cornell.cs.sam.io.*;
import edu.cornell.cs.bali.compiler.*;

public class Main implements ASTNode {
    
    private ASTNode decls;      
    private ASTNode stats;      
    private String  bali;
    
    public Main(Tokenizer f) throws IllegalBaliException {
	beginMain(f);
	compileDeclBlock(f);
	compileStatBlock(f);
	endMain(f);
    }
    
    // Begin Main Function:
    private void beginMain(Tokenizer f) throws IllegalBaliException {
	bali = "";
	bali += f.getWord(); // eat "main"
	bali += " " + f.getOp() + "\n";  // eat "{"
    }
    
    // Compile the variable declarations:
    private void compileDeclBlock(Tokenizer f) throws IllegalBaliException {
	decls = new DeclBlock(f);
	bali += decls.toBali();
    }
    
    // Compile the statement block: 
    private void compileStatBlock(Tokenizer f) throws IllegalBaliException {
	stats = new StatBlock(f);
	bali += stats.toBali();
    }
    
    // End Main Function:
    private void endMain(Tokenizer f) throws IllegalBaliException {
	bali += f.getOp() + "\n" ;  // eat "}"
    }

    public String toSamcode() {
	return
	    "main:\n" + 
	    "ADDSP "+ (1 + ((DeclBlock) decls).getVarCount() ) + "\n" + 
	     stats.toSamcode() +
	    "mainend:\n" +
	    "PUSHIMM 0\n" +  // default return value
	    "STOREOFF 0\n" + // store the default rv
	    "ADDSP -" + ((DeclBlock) decls).getVarCount() + "\n";
    }
    
    public String toAST(String tab) {
	return 
	    tab + this + "\n" +
	    decls.toAST(tab+TABBY) +
	    stats.toAST(tab+TABBY) ;
    }
    
    public String toBali() {
	return bali;
    }

    public String toString() {
	return getClass().getName();
    }
    
}
