// Integer Expressions

import edu.cornell.cs.sam.io.*;
import edu.cornell.cs.bali.compiler.*;

public class IntExpr implements ASTNode {
    
    private int value;
    private String bali;
    
    public IntExpr(Tokenizer f) throws IllegalBaliException {
	bali = "";
	value = f.getInt();
	bali += value;
    }

    // Generate code:
    public String toSamcode() {
        return "PUSHIMM "+value+"\n";
    }
    
    public String toAST(String tab) {
	return tab + this + "\n";
    }

    public String toBali() {
	return bali;
    }
    
    public String toString() {
	return getClass().getName();
    }
    
}
