// If Statement Node
import edu.cornell.cs.sam.io.*;
import edu.cornell.cs.bali.compiler.*;
import java.util.*;

public class IfStat implements ASTNode {
    
    private String name;
    private String bali;
    private ASTNode condition;
    private ASTNode stats;

    public IfStat(Tokenizer f) throws IllegalBaliException {
	compileIf(f);
    }

    public void compileIf(Tokenizer f) throws IllegalBaliException {
	bali = "";
	bali += "if"; 
	bali += f.getOp(); // if (
	condition = new Expr(f);
	bali += condition.toBali();
	bali += f.getOp(); // if ( cond )
	stats = new StatBlock(f);
	bali += stats.toBali();
    }

    public String toSamcode() {
	String sam = "";
	int LC = Program.labelCount;
 	sam += condition.toSamcode();
	sam += "JUMPC "+"correct" +LC+"\n";
	sam += "JUMP " +"continue"+LC+"\n";
	sam += "correct" +LC+":\n";
	Program.labelCount++; // in case we have more if statements
	sam += stats.toSamcode();
	sam += "JUMP " +"continue"+LC+"\n";
	sam += "continue" +LC+":\n";
	return sam;
    }
    
    public String toAST(String tab) {
	return tab + this + "\n" + 
	    condition.toAST(tab+TABBY) + stats.toAST(tab+TABBY);
    }

    public String toBali() {
	return bali;
    }
    
    public String toString() {
	return getClass().getName();
    }
    
}
