// Expressions

import edu.cornell.cs.sam.io.*;
import edu.cornell.cs.bali.compiler.*;

public class Expr implements ASTNode {
    
    private ASTNode left;
    private ASTNode right;
    private String bali;
    private char op = '0';
    
    public Expr(Tokenizer f) throws IllegalBaliException {
	bali = "";
	compileExpr(f);
    }
    
    public void compileExpr(Tokenizer f) throws IllegalBaliException {
	
	bali = "";
	switch( f.peekAtKind() ) {
	case INTEGER: // E -> int
	    left = new IntExpr(f);
	    right = null;
	    bali += left.toBali();
	    break;      

	case WORD: // need to retrieve value!
	    String name = f.getWord();
	    left = new NameExpr(name,f);
	    right = null;
	    bali += left.toBali();
	    break;      
	
	case OPERATOR:   // E -> (E1 + E2)
            bali += f.getOp();      // eat "("
            left = new Expr(f);     // E1
            bali += left.toBali();  
	   op = f.getOp();         // either + or < 
	   bali += op;             
	   right = new Expr(f);    // E2
            bali += right.toBali();
	   bali += f.getOp();      // eat ")"
            break;

        default: // Unknown Expression
            System.out.println("Unknown expression error.");
            System.exit(1);
	    
	} // end switch

    }

    // Generate code:
    public String toSamcode() {
        String s = "";
        if (left != null)  
	    s += left.toSamcode();
        if (right != null) { 
	    s += right.toSamcode();
	    if (op=='+')
		s += "ADD\n";
	    else if (op=='<')
		s += "LESS\n";
        }
        return s;
    }
    
    public String toAST(String tab) {
	String tree = tab;
;
	if (op=='+') tree += "ADD_";
	else if (op=='<') tree += "LESS_";

	tree += this + "\n";

	if (left != null)  
	    tree += left.toAST(TABBY+tab);
	if (right != null) 
	    tree += right.toAST(TABBY+tab);
	return tree;
    }

    public String toBali() {
	return bali;
    }
    
    public String toString() {
	return getClass().getName();
    }
    
}
