// DeclBlock Node
import edu.cornell.cs.sam.io.*;
import edu.cornell.cs.bali.compiler.*;
import java.util.*;

public class DeclBlock implements ASTNode {
    
    private static HashMap<String,Integer> symbolTable;
    private Vector<ASTNode> decls;
    private int varcount;
    private String bali;
    
    public DeclBlock(Tokenizer f) throws IllegalBaliException {
	beginDecls(f);
	compileDecls(f);
	endDecls(f);
    }
    
    public void beginDecls(Tokenizer f) throws IllegalBaliException {
	bali = "";
	bali += f.getOp()+"\n";   // eat "{"
    }
    
    public void compileDecls(Tokenizer f) throws IllegalBaliException {
	symbolTable = new HashMap<String,Integer>(0);
	decls = new Vector<ASTNode>(0);
	int offset = 0;
 	while ( f.peekAtKind() != Tokenizer.TokenType.OPERATOR ) {
	    Decl d = new Decl(f);
	    decls.add(d);
	    symbolTable.put( ((Decl) d).getName(), ++offset );
	    bali += d.toBali();
	}
	varcount = symbolTable.size();
    }
    
    public void endDecls(Tokenizer f) throws IllegalBaliException {
	bali += f.getOp() + "\n";  // eat "}"
    }
    
    public static HashMap getSymbolTable() {
	return symbolTable;
    }

    public int getVarCount() {
	return varcount;
    }

    public String toSamcode() {
	return "ADDSP "+varcount;
    }
    
    public String toAST(String tab) {
	String pt = tab + this + "\n";
	for (int i = 0; i < varcount ; i++)
	    pt += ((Decl) (decls.get(i))).toAST(tab+TABBY);
	return pt;
    }

    public String toBali() {
	return bali;
    }
    
    public String toString() {
	return getClass().getName();
    }
    
}
