// Decl Node
import edu.cornell.cs.sam.io.*;
import edu.cornell.cs.bali.compiler.*;
import java.util.*;

public class Decl implements ASTNode {
    
    private String name;
    private String bali;

    public Decl(Tokenizer f) throws IllegalBaliException {
	compileDecl(f);
    }

    public void compileDecl(Tokenizer f) throws IllegalBaliException {
	bali = "";
	bali += f.getWord() ; // eat "int"
	name = f.getWord();   // var name
	bali += " " + name + " " + f.getOp() + "\n"; // eat ";"
    }

    public String getName() {
	return name;
    }

    public String toSamcode() {
	return "";
    }
    
    public String toAST(String tab) {
	return tab + this + "\n";
    }

    public String toBali() {
	return bali;
    }
    
    public String toString() {
	return getClass().getName();
    }
    
}
