import java.io.*;
import edu.cornell.cs.sam.io.*;
import edu.cornell.cs.bali.compiler.*;

public class BC { 

    private static Tokenizer finger;       // lexer
    private static CS212Out  samFile;      // sam  -> File
    private static CS212Out  baliASTFile;  // Bali -> File
    private static CS212Out  baliCopyFile; // Bali -> Bali
    private static String    samCode;      // sam  -> String
    private static String    baliAST;      // Bali -> abstract syntax tree
    private static String    baliCopy;     // Bali -> copy

    // Compile Bali into sam:
    public static void main(String[] args) throws Exception {
	setup(args);    // set I/O option
	compile();      // compile Bali code
	printOutput();  // output Samcode and debug info
	cleanup();      // close I/O
    }

    // Create input and output files (lexer, Sam output, Parse Tree output):
    private static void setup(String[] args) throws Exception {
	
	try {

	    // Check command-line arguments:
	    if ( args.length != 1 ) {
		System.out.println("Usage: java BC <name> (no '.bali')");
		System.exit(1);
	    }

	    // Lexer:
	    finger = new SamTokenizer(args[0]+".bali");

	    // Output files:
	    samFile      = new CS212Out(args[0] + ".sam");
    	    baliASTFile  = new CS212Out(args[0] + ".txt");
    	    baliCopyFile = new CS212Out(args[0] + "copy.bali");
	}

	catch ( IOException e ) {
	    System.out.println("I/O Error: " + e.getMessage());
	    System.exit(0);
	}
    }

    // Compile Bali program; the BaliCompiler stores the AST, Samcode, parse tree:
    private static void compile() throws Exception {

	try {
	    BaliCompiler bc = new BaliCompiler();
	    samCode  = bc.compile(finger);
	    baliAST  = bc.AST();
	    baliCopy = bc.copy(); 
	}
	catch(IllegalBaliException e) {
	    System.out.println(e);
	}

    }
	
    // Print output files:
    private static void printOutput() throws Exception {
	samFile.println(samCode);  
	baliASTFile.println(baliAST);
	baliCopyFile.println(baliCopy);
    }

    // Close file streams:
    private static void cleanup() throws Exception {
	try {
	    finger.close();
	    samFile.close();
	    baliASTFile.close();
	}
	catch ( Exception e ) {
	    System.out.println("I/O Error: " + e.getMessage());
	    System.exit(0);
	}
    }

} // Class BC
