// Assign Statement Node
import edu.cornell.cs.sam.io.*;
import edu.cornell.cs.bali.compiler.*;
import java.util.*;

public class AssignStat implements ASTNode {
    
    private String name;
    private int offset;
    private String bali;
    private ASTNode expr;

    public AssignStat(String name, Tokenizer f) throws IllegalBaliException {
	this.name = name; // varname being assigned
	compileAssign(f);
    }

    public void compileAssign(Tokenizer f) throws IllegalBaliException {
	bali = "";
	bali += name + " "; // name
	bali += f.getOp();  // = 
	offset = ( (Integer) (DeclBlock.getSymbolTable().get(name) ) ).intValue();
	expr = new Expr(f); // expr
	bali += expr.toBali();
	bali += f.getOp() + "\n"; // ";"
    }


    public String toSamcode() {
	String sam = "";
	sam += expr.toSamcode();
	sam += "STOREOFF " + offset + "\n";
	return sam;
    }
    
    public String toAST(String tab) {
	return tab + this + "\n" + 
	    tab+TABBY+"Name\n" + 
	    expr.toAST(tab+TABBY);
    }

    public String toBali() {
	return bali;
    }
    
    public String toString() {
	return getClass().getName();
    }
    
}
