package edu.cornell.cs.cs212.sp2004.part3;
import java.util.Vector;
/**
 * MultipleBaliException allows for the reporting of more than one error.
 * The suggested method of use is to create an exception at the start of compilation,
 * and add errors to it as they are found. if countErrors() > 0 at the end, the
 * exception should then be thrown.
 */
public class MultipleBaliException extends IllegalBaliException {

	private String message = "Multiple Bali Errors";
	private Vector errors = new Vector();

	/*  Constructors */
	public MultipleBaliException() {}

	/* Handling for Multiple Errors */
	public void addError(IllegalBaliException e){
		errors.add(e);
	}

	/* Return number of errors */
	public int countErrors(){
		return errors.size();
	}

	/* Return vector of errors */
	public Vector getErrors(){
		return errors;
	}

	/* Error Retrieval */
	public String getMessage() { return message; }

	public String toString(){
		String toReturn = message;
		for(int i = 0; i < errors.size(); i++){
			toReturn += "Error " + (i+1) + ":\n" + ((IllegalBaliException)errors.get(i)).toString() + "\n\n";
		}
		return toReturn;
	}
}
