package edu.cornell.cs.cs212.sp2004.part3;
/**
 * Used for errors with the compiler
 */
public class BaliSyntaxException extends IllegalBaliException {

        private String message = "Unspecified Syntax Error";
        private int line = -1;

        /*  Constructors */
        public BaliSyntaxException() {}
        public BaliSyntaxException(String msg) { message = msg; }
        public BaliSyntaxException(int lc) { line = lc; }
        public BaliSyntaxException(String msg, int lc) {
                message = msg;
                line = lc;
        }

        /* Error Retrieval */
        public String getMessage() { return message; }
        public int getLine() { return line; }
        public String toString() 
                { return (line > -1) ? (message + ": line " + line) : message; }
}
