package edu.cornell.cs.cs212.sp2004.part3;
/**
 * Used for errors with the compiler
 */
public class BaliSemanticException extends IllegalBaliException {

        private String message = "Unspecified Semantic Error";
        private int line = -1;

        /*  Constructors */
        public BaliSemanticException() {}
        public BaliSemanticException(String msg) { message = msg; }
        public BaliSemanticException(int lc) { line = lc; }
        public BaliSemanticException(String msg, int lc) {
                message = msg;
                line = lc;
        }

        /* Error Retrieval */
        public String getMessage() { return message; }
        public int getLine() { return line; }
        public String toString() 
                { return (line > -1) ? (message + ": line " + line) : message; }
}
