import java.util.*;
import java.io.*;

/**
 *
 * <p>Title: public class ElectionsInfo</p>
 * <p>Description: Defines a thread-safe object for storing and retreiving
 * election objects</p>
 */
public class ElectionsInfo {
  //A hashtable to hold the Election objects
  private Hashtable electionHash;

  //Constructor takes no arguments
  public ElectionsInfo() {
    electionHash = new Hashtable();
  }

  /**
   * Adds an Election object
   * @param election the Election object to add
   */
  public synchronized void addElection(Election election) {
    if(election == null || election.getName() == null) return;
    electionHash.put(election.getName(), election);
  }

  /**
   * Adds a candidate to a specified election
   * @param election the election name, as a String
   * @param cand the Candidate object to add to the election
   */
  public synchronized void addCandidate(String election, Candidate cand) {
    try {
      Election e = (Election) electionHash.get(election);
      e.addCandidate(cand);
    }
    catch(Exception ex) {}
  }

  /**
   * Returns the Election object with the given name
   * @param electionName the name of the election
   * @return the Election object with name electionName
   */
  public synchronized Election getElection(String electionName) {
    Object obj = electionHash.get(electionName);
    if(obj == null || !(obj instanceof Election))
      return null;
    return (Election)obj;
  }

  /**
   * Returns a boolean indicating if an Election object with the given name
   * exists
   * @param electionName the name of the Election to check for
   * @return a boolean indicating if the Election exists
   */
  public synchronized boolean containsElection(String electionName) {
    Object obj = electionHash.get(electionName);
    return (obj != null && obj instanceof Election);
  }

  /**
   * Clears this set of Election objects
   */
  public synchronized void clear() {
    electionHash.clear();
  }

  /**
   * Copies all Election objects and returns them in a Vector
   * @param hideInfo a boolean indicating if information about the election,
   * such as vote counts and the election status (open or closed) should be
   * hidden and set to default values
   * @return the Vector of copied Elections
   */
  public synchronized Vector getElectionCopies(boolean hideInfo) {
        Vector v = new Vector();
        Iterator i = electionHash.values().iterator();
        //Add a copy of each election to the vector
        while(i.hasNext()) {
          Object obj = i.next();
          if(obj instanceof Election)
            v.add( ((Election)obj).copy(hideInfo) );
        }
        //return the Vector of Elections
        return v;
  }

}