import java.net.*;
import java.io.*;
import java.lang.Thread;

public class ConnectionMonitor extends Thread {
  private ElectionServer gui;
  private ElectionsInfo electionsInfo;


  //Constructor takes in the Socket to communicate through
  public ConnectionMonitor(ElectionServer serverGUI, ElectionsInfo info) {
    gui = serverGUI;
    electionsInfo = info;
  }

  //Override the run() method for this thread type
  public void run() {
    //A server socket for accepting incoming connections
    ServerSocket serverSocket = null;
    //A temporary socket field
    Socket socket;

    try {
        //Make the server socket.  This is ONLY used for accepting incoming
        //connection requests, not for other communication
        serverSocket = new ServerSocket(7777);

        //Wait for a client to connect.  Upon connection, get the new socket
        //to use for communication with the client.  Then loop back and wait
        //for the next client to connect
        while(true) {
          socket = serverSocket.accept();
          ServerThread thread = new ServerThread(socket, gui, electionsInfo);
          thread.start();
          System.out.println("Accepted connection from "
                             + socket.getInetAddress().getHostAddress()
                             + " on port " + socket.getPort());
        }
      }
      catch (UnknownHostException e) {
        System.err.println("Don't know about host: localhost.");
        System.exit(1);
      }
      catch (IOException e) {
        System.err.println("Couldn't get I/O for the connection to: localhost.");
        System.exit(1);
      }

      //Close the server socket at the end
      try {
        serverSocket.close();
      }
      catch(Exception e) {}
  }
}

