
import java.io.*;

//Class to enter in Candidate name and vote count
public class Candidate implements Serializable {
  //A candidate has a name and a number of votes
  private String name;
  private int voteCount;

  //Constructor takes in a name. Votes start at 0
  public Candidate(String name) {
    this.name = name.trim();
    voteCount = 0;
  }

  //Constructor that takes in a Candidate and returns a clone
  public Candidate(Candidate cand) {
    this.name = cand.getName();
    this.voteCount = cand.getVoteCount();
  }


  //Constructor takes in a name and an initial amount of votes
  public Candidate(String name, int voteCount) {
    this.name = name;
    this.voteCount = voteCount;
  }


  //Getter function for the name
  public synchronized String getName() {
    return new String(name);
  }

  //Increments the vote count for this candidate
  public synchronized void incVote() {
    voteCount++;
  }

  //Getter and setter functions for the vote count
  public synchronized int getVoteCount() {
    return voteCount;
  }

  //Sets the vote count for this candidate.  Cannot go below 0
  public synchronized void setVoteCount(int votes) {
    voteCount = Math.max(0, votes);
  }

  /**
   * Returns a String representation of this Candidate object.  For use in
   * with the JList of candidates
   */
  public synchronized String toString() {
    return name + "   " + voteCount;
  }

}

