import java.util.*;

/**
 * This class defines a queue of Message objects
 */
public class MessageQueue {
  //Implement the queue using a linked list
  private LinkedList messages;

  //Constructor
  public MessageQueue() {
    messages = new LinkedList();
  }

  //Enqueues a message
  public synchronized void addMessage(Message m) {
    //Add message to end of the linked list
    messages.add(m);
  }

  //Retuns the next message in the queue, or null if the queue is empty
  public synchronized Message getNextMessage() {
    if(messages.isEmpty()) return null;
    return (Message) messages.remove(0);
  }

  //Returns a boolean indicating if the queue is empty
  public synchronized boolean isEmpty() {
    return messages.isEmpty();
  }

  public synchronized void prependDisconnectMessage() {
    messages.add(0, Message.getDisconnectMessage());
  }

}