
import java.util.Vector;
import java.io.Serializable;



public class Message implements Serializable{
  //Types of messages:
  //Client trying to connect
  public static int CONNECT = 0;
  //Client trying to vote
  public static int VOTE = 1;
  //Text message to display to the user, generally sent from server to
  //clientin response to a client request
  public static int TEXT_MSG = 2;
  //Server sending info about elections to client
  public static int ELECTIONS_INFO = 3;
  //Client ending connection
  public static int DISCONNECT = 4;

  //The type of message this is
  private int type;
  //Username and password for connecting or voting
  private String username, password;
  //election and candidate name for voting
  private String election, candidate;
  //A text message to display to the user
  private String msg;
  //Vector of election info for client to display
  public Vector elections;

  /**
   * Private constructor.  Making the constructor private allows us to write
   * static methods that create the type of message wanted, and limits
   * access to the internal fields of the object
   */
  private Message() {
    type = -1;
  }


  /**
   * Creates a Message object indicating that the client wants to connect
   * to the server
   * @param username username of the voter
   * @param password password of the voter
   * @return the Message object to be sent to the server
   */
  public static Message getConnectMessage(String username, String password) {
    Message m = new Message();
    m.type = CONNECT;
    m.username = username;
    m.password = password;
    return m;
  }


  /**
   * Creates a Message object indicating the candidate and election the client
   * is voting for
   * @param username username of the voter
   * @param password password of the voter
   * @param election the name of the election in which the client is voting
   * @param candidate the name of the candidate the client is voting for
   * @return the Message object to be sent to the server
   */

  public static Message getVoteMessage(String username, String password,
                                       String election, String candidate) {
    Message m = new Message();
    m.type = VOTE;
    m.username = username;
    m.password = password;
    m.election = election;
    m.candidate = candidate;
    return m;
  }


  /**
   * Creates a Message object for a simple text message
   * @param message the text message to be sent
   * @return the Message object to be sent
   */
  public static Message getTextMessage(String message) {
    Message m = new Message();
    m.type = TEXT_MSG;
    m.msg = message;
    return m;
  }


  /**
   * Creates a Message object for sending election info to the client
   * @param elections the Vector of Election objects to send
   * @return the Message object to send to the client
   */
  public static Message getElectionsInfoMessage(Vector elections) {
    Message m = new Message();
    m.type = ELECTIONS_INFO;
    m.elections = elections;
    return m;
  }

  /**
   * Creates a Message object for closing the connection, which the client
   * send to the server
   * @return
   */
  public static Message getDisconnectMessage() {
    Message m = new Message();
    m.type = DISCONNECT;
    return m;
  }

  //Return the type of message
  public int getType() {
    return type;
  }

  //Return the election name
  public String getElectionName() {
    return new String(election);
  }

  //Return the candidate name
  public String getCandidateName() {
    return new String(candidate);
  }

  //Return the username
  public String getUsername() {
    return new String(username);
  }

  //Return the password
  public String getPassword() {
    return new String(password);
  }

  //Return the text message
  public String getTextMessage() {
   return new String(msg);
 }

 //A String representation of this message
 public String toString() {
   String s = "";
   if (type == CONNECT) {
     s += "Connect message, username = " + username + ", password = " +
         password;
   }
   else if (type == VOTE) {
     s += "Vote message, username = " + username + ", password = " + password
         + ", election = " + election + ", candidate = " + candidate;
   }
   else if (type == TEXT_MSG) {
     s += "Text message: " + msg;
   }
   else if (type == ELECTIONS_INFO) {
     s += "Elections info message";
   }
   else if (type == DISCONNECT) {
     s += "Disconnect message";
   }

   return s;
 }

}



