

import java.io.*;

//Class to enter in Candidate name and vote count
public class Candidate {
  //A candidate has a name and a number of votes
  private String name;
  private int voteCount;

  //Constructor takes in a name. Votes start at 0
  public Candidate(String candidateName) {
    this.name = candidateName;
    voteCount = 0;
  }

  //Constructor takes in a name and an initial amount of votes (>= 0)
  public Candidate(String candidateName, int initialVotes) {
    this.name = candidateName;
    this.voteCount = Math.max(0, initialVotes);
  }


  //Getter function for the name
  public String getName() {
    return name;
  }

  //Increments the vote count for this candidate
  public void incVote() {
    voteCount++;
  }

  //Getter and setter functions for the vote count
  public int getVoteCount() {
    return voteCount;
  }

  //Sets the vote count for this candidate.  Cannot go below 0
  public void setVoteCount(int votes) {
    voteCount = Math.max(0, votes);
  }

  /**
   * Returns a String representation of this Candidate object.  For use in
   * with the JList of candidates
   */
  public String toString() {
    return name + "   " + voteCount;
  }
}

