

import java.io.*;
import java.util.*;

/**
 * Class that represents an election.  Contains a name, a hashtable of
 * candidates, and a boolean indicating if the election is open or not.
 */
public class Election {
  //Class fields
  protected String electionName;
  protected Hashtable candidateHash;
  protected boolean open;

  //Constructor.  Takes in a name and a hashtable of candidates.
  //Initially, all elections are closed
  public Election(String name) {
    electionName = name;
    candidateHash = new Hashtable();
    open = false;
  }


  //Get the name of the election
  public String getName() {
    return electionName;
  }


  //Getter and setter function
  public Hashtable getCandidateHash() {
    return candidateHash;
  }

  //Gets a Vector of candidate names as Strings
  public Vector getCandidateNames() {
    Vector names = new Vector();
    Enumeration enum = candidateHash.keys();
    //Iterate through candidates, add each name to vector
    while(enum.hasMoreElements()) {
      names.add((String) enum.nextElement());
    }
    return names;
  }

  //Getter and setter operations for open status
  public void setOpen()   { open = true; }
  public void setClosed() { open = false; }
  public boolean isOpen() { return open; }


  //This function resets all votes for all candidates to 0.  This is
  //useful when an election has been reopened
  public void resetVotes() {
    Enumeration enum = candidateHash.keys();
    while (enum.hasMoreElements()) {
      String candName = (String)enum.nextElement();
      ((Candidate)candidateHash.get(candName)).setVoteCount(0);
    }
  }


  /**
   * Adds a candidate to the election if the candidate does not exist in
   * in the election.
   * @param cand the Candidate object to add
   * @return a boolean indicating if the candidate was added
   */
  public boolean addCandidate(Candidate cand) {
    //If the candidate exists, just return false
    String name = cand.getName();
    if(candidateHash.contains(name))
      return false;
    //Otherwise, add the candidate and return true
    candidateHash.put(cand.getName(), cand);
    return true;
  }


  /**
   * Returns a String representation of this Election object.  For use in
   * with the JList of elections
   */
  public String toString() {
    String s = electionName + "  ";
    if (open)
      return s += "(OPEN)";
    else
      return s += "(CLOSED)";
  }
}
