


import javax.swing.*;
import java.awt.*;
import java.awt.event.*;
import java.net.*;
import java.io.*;
import java.util.*;

public class ConnectionDialog extends JDialog implements ActionListener {
  //GUI components:
  protected JPanel main, namePanel, passPanel, buttonPanel;
  protected JLabel name, pass;
  protected JTextField nameField;
  protected JPasswordField passField;
  protected JButton OK, cancel;
  private int textFieldColumns = 25;
  //Return values:
  public static final int OK_OPTION = 0;
  public static final int CANCEL_OPTION = 1;
  protected int returnVal = CANCEL_OPTION;


  //Constructor
  public ConnectionDialog() {
    //Create panels
    main = new JPanel(new GridLayout(4,1));
    namePanel = new JPanel(new FlowLayout(FlowLayout.RIGHT));
    passPanel = new JPanel(new FlowLayout(FlowLayout.RIGHT));
    buttonPanel = new JPanel(new FlowLayout(FlowLayout.CENTER, 50,5));

    //Create vote info label
    main.add(new JLabel("Enter username and password to connect", JLabel.CENTER));

    //Create name and password panels
    name = new JLabel("Username: ");
    nameField = new JTextField(textFieldColumns);
    namePanel.add(name);
    namePanel.add(nameField);
    main.add(namePanel);

    pass = new JLabel("Password: ");
    passField = new JPasswordField(textFieldColumns);
    //Add a KeyListener so user can type ENTER when done entering pass phrase
    passField.addActionListener(this);

    passPanel.add(pass);
    passPanel.add(passField);
    main.add(passPanel);

    //Create buttons and add to button panel
    OK = new JButton("OK");
    OK.addActionListener(this);
    OK.setActionCommand("ok");
    passField.setActionCommand(OK.getActionCommand());

    buttonPanel.add(OK);
    cancel = new JButton("Cancel");
    cancel.addActionListener(this);
    cancel.setActionCommand("cancel");
    buttonPanel.add(cancel);
    main.add(buttonPanel);


    this.setModal(true);
    this.setTitle("Voter Authentication");
    this.getContentPane().add(main);
    this.pack();
    this.setResizable(false);
  }


  //Define the actionPerformed() method from the ActionListener interface.
  //Handles the OK and Cancel buttons
  public void actionPerformed(ActionEvent event) {
    if(event.getActionCommand().equalsIgnoreCase("ok")) {
      returnVal = OK_OPTION;
      this.dispose();
    }

    if(event.getActionCommand().equalsIgnoreCase("cancel")) {
      returnVal = CANCEL_OPTION;
      this.dispose();
    }
  }





  /**
   * This function show()'s the dialog, thus preventing the user
   * from accessing the parent GUI until the dialog box is filled out and
   * submitted, or is closed.  Returns a value indicating if the dialog was
   * submitted or closed (canceled).
   */
  public int showAddVoterDialog() {
    this.show();
    return returnVal;
  }

  //Getter function for user name input
  public String getUserName() {
    return nameField.getText();
  }

  //Getter function for password input
  public String getPassword() {
    return new String(passField.getPassword());
  }






  //If the window is closed, exit
//  public void windowClosing(WindowEvent event) {
//    this.dispose();
//  }
//
//  public void windowClosed(WindowEvent event) {}
//  public void windowDeiconified(WindowEvent event) {}
//  public void windowIconified(WindowEvent event) {}
//  public void windowActivated(WindowEvent event) {}
//  //If the client GUI is chosen, put popup window back in front until userName
//  //and password are entered, or popup is closed
//  public void windowDeactivated(WindowEvent event) {
//    if(client.isEnabled()) this.toFront();
//  }
//
//  public void windowOpened(WindowEvent event) {}


  public static void main(String[] args) {

  }




}