import java.io.InputStream;
import java.util.Iterator;

/**
 * A stream that can be iterated over.
 */
public class IterableStream implements Iterable<Byte> {

	/** Underlying stream */
	private InputStream stream;

	/**
	 * Create a new iterable stream
	 * 
	 * @param s The stream to wrap
	 */
	public IterableStream(InputStream s) {
		stream = s;
	}

	@Override
	public Iterator<Byte> iterator() {
		return new ByteStreamIterator();
	}

	/**
	 * An iterator over an iterable stream. Will read from the stream, so it is not
	 * safe to read from the stream outside of this iterator, or to create multiple
	 * iterators wrapping the same stream.
	 */
	private class ByteStreamIterator implements Iterator<Byte> {

		//
		// Do NOT use:
		// - available()
		// - mark()
		// - reset()
		//
		// In fact, this whole class can be written with just stream.read()
		//
		// Do not attempt to read the entire stream into memory at once.
		//
		// Hint: you may want some more instance variables.
		//

		/**
		 * Create a new iterator over an input stream. It is not safe to have more than
		 * one iterator on the same stream.
		 */
		public ByteStreamIterator() {

		}

		@Override
		public boolean hasNext() {
			// TODO Auto-generated method stub
			return false;
		}

		@Override
		public Byte next() {
			// TODO Auto-generated method stub
			return null;
		}

	}
}
