import static org.junit.jupiter.api.Assertions.assertEquals;
import static org.junit.jupiter.api.Assertions.assertFalse;
import static org.junit.jupiter.api.Assertions.assertTrue;
import static org.junit.jupiter.api.Assertions.fail;

import java.util.Collections;
import java.util.Iterator;
import java.util.List;
import java.util.NoSuchElementException;
import java.util.stream.Collectors;
import java.util.stream.Stream;

import org.junit.jupiter.api.Test;

class BSTTest {

	@Test
	public void simpleIteratorTest() {
		BST<Integer> t = new BST<Integer>();
		t.add(3);
		t.add(1);
		t.add(5);
		t.add(0);
		t.add(2);
		t.add(4);
		t.add(6);

		Iterator<Integer> itr = t.iterator();
		for (int i = 0; i < 10; i++) {
			assertTrue(itr.hasNext());
		}
		for (int i = 0; i < 7; i++) {
			int val = itr.next();
			assertEquals(i, val, "Value should be " + i);
		}
		try {
			itr.next();
			fail("NoSuchElementException should be thrown");
		} catch (NoSuchElementException e) {
		}
		assertFalse(itr.hasNext(), "hasNext() should be false");
		assertEquals(7, t.size(), "Tree size should be 7");
	}

	@Test
	public void largeRandomTest() {
		final int MAX_NUM = 10000;

		// Randomly shuffle numbers 0 to 10,000 (exclusive)
		List<Integer> numberList = Stream.iterate(0, s -> s < MAX_NUM, s -> s + 1).collect(Collectors.toList());
		Collections.shuffle(numberList);

		BST<Integer> tree = new BST<>();

		for (Integer e : numberList) {
			assertTrue(tree.add(e));
		}
		for (int i = 0; i < MAX_NUM; i++) {
			assertTrue(tree.contains(i));
			assertFalse(tree.add(i));
		}

		assertEquals(MAX_NUM, tree.size());

		int i = 0;
		for (Integer e : tree) {
			assertEquals(i++, e);
		}
	}

}
