import static org.junit.jupiter.api.Assertions.assertEquals;
import static org.junit.jupiter.api.Assertions.assertFalse;
import static org.junit.jupiter.api.Assertions.assertThrows;
import static org.junit.jupiter.api.Assertions.assertTrue;

import java.util.Iterator;
import java.util.NoSuchElementException;

import org.junit.jupiter.api.Test;

class LinkedListTest {

	@Test
	public void testLinkedListIterator() {
		LinkedList<Integer> l = new LinkedList<Integer>();
		for (int i = 0; i < 10; i++)
			l.add(i);
		assertEquals(10, l.size(), "List size should be 10");

		Iterator<Integer> itr = l.iterator();

		for (int i = 0; i < 10; i++) {
			int val = itr.next();
			assertEquals(i, val, "Value should be " + i);
		}

		assertThrows(NoSuchElementException.class, itr::next);
		assertFalse(itr.hasNext(), "hasNext() should be false");

		itr = l.iterator();
		for (int i = 0; i < 10; i++) {
			assertTrue(itr.hasNext(), "hasNext() should be true");
			int val = itr.next();
			assertEquals(i, val, "Value should be " + i);
		}
		assertFalse(itr.hasNext(), "hasNext() should be false");
		assertThrows(NoSuchElementException.class, itr::next);

	}

}
