import static org.junit.jupiter.api.Assertions.assertEquals;
import static org.junit.jupiter.api.Assertions.assertFalse;
import static org.junit.jupiter.api.Assertions.assertThrows;
import static org.junit.jupiter.api.Assertions.assertTrue;

import java.io.ByteArrayInputStream;
import java.io.InputStream;
import java.util.Iterator;
import java.util.NoSuchElementException;

import org.junit.jupiter.api.Test;

class IterableStreamTest {

	final int ARR_SIZE = 50;

	@Test
	void test() {
		byte[] byteArray = new byte[ARR_SIZE];
		for (int i = 0; i < ARR_SIZE; i++) {
			byteArray[i] = (byte) i;
		}
		InputStream is = new ByteArrayInputStream(byteArray);

		IterableStream iterStream = new IterableStream(is);
		Iterator<Byte> iter = iterStream.iterator();

		for (byte b : byteArray) {
			assertTrue(iter.hasNext());
			assertEquals(b, iter.next());
		}

		assertFalse(iter.hasNext());

		assertThrows(NoSuchElementException.class, iter::next);
	}

}
