package cs2112.lecture20;

import java.util.Random;

public class Deadlock {
    static class InsufficientFunds extends Exception { }

    static class Account {
        int balance = 10;

        synchronized void withdraw(int n) throws InsufficientFunds {
            if (balance < n) throw new InsufficientFunds();
            balance -= n;
        }
        synchronized void deposit(int n) { balance += n; }
    }

    final static int NA = 1000;
    static Account[] accounts = new Account[NA];
    static Random rand = new Random();

    public static void main(String[] args) {
        for (int i = 0; i < NA; i++) accounts[i] = new Account();
        new Thread(() -> runTransactions("A")).start();
        new Thread(() -> runTransactions("B")).start();
    }

    static final int NT = 1000000;
    static void runTransactions(String id) {
        for (int t = 0; t < NT; t++) {
            if (t % (NT/100) == 0) System.out.print(id + ":" + t + " ");
            int i = rand.nextInt(NA), j = rand.nextInt(NA), k = rand.nextInt(NA);
            int withdrawn = 0;
            synchronized (accounts[i]) {
                synchronized (accounts[j]) {
                    try {
                        accounts[i].withdraw(1); withdrawn++;
                        accounts[j].withdraw(1); withdrawn++;
                        accounts[k].deposit(withdrawn);
                    } catch (InsufficientFunds exc) {
                        if (withdrawn == 1) accounts[i].deposit(1);
                    }
                }
            }
        }
    }
}
