package cs2112.lecture20;

public class Bank {

    static class Account {
        int balance;
        void withdraw(int n) { balance -= n; }
        void deposit(int n) { balance += n; }
    }

    public static void main(String[] args) {
        final Account b = new Account();
        final int count = 1000000;
        Thread t1 = new Thread() {
            public void run() {
                for (int i = 0; i < count; i++)
                    b.withdraw(1);
            }
        };
        Thread t2 = new Thread() {
            public void run() {
                for (int i = 0; i < count; i++)
                    b.deposit(1);
            }
        };
        t1.start();
        t2.start();
        waitForThreadToFinish(t1);
        waitForThreadToFinish(t2);
        System.out.println("current balance is " + b.balance);
    }

    /** Wait until thread t finishes */
    static void waitForThreadToFinish(Thread t) {
        boolean done = false;
        while (!done) {
            try {
                t.join();
                done = true;
            } catch (Exception e) {
                System.out.println("Could not join thread" + e);
            }
        }
    }
}
