package mvcDemo;

import javafx.scene.canvas.Canvas;
import javafx.scene.canvas.GraphicsContext;
import javafx.scene.effect.BlendMode;
import javafx.scene.paint.Color;
import javafx.scene.paint.Paint;

/**
 * This class should be considered part of the view.
 * Rightly it should be declared as a subclass of Canvas,
 * but the SceneBuilder and FXML do not support this kind of
 * subclassing of components very well. So to use FXML with
 * the Canvas, we instead use the Aggregation design pattern,
 * in which the Grid 'owns' the Canvas.
 * 
 * All methods are called only on the Application thread.
 */
public class Grid {
   private final int N = Controller.N;
   private final int SIZE = Controller.SIZE;
   private final boolean USE_RAINBOW_COLORS = Controller.USE_RAINBOW_COLORS;
   private final Color[] rainbow = {
      Color.RED, Color.ORANGE, Color.YELLOW,
      Color.GREEN, Color.BLUE, Color.VIOLET };
   private Paint background = Color.BLACK;
   private final GraphicsContext g;
   private final Model model;
   
   public Grid(Model model, Canvas canvas) {
      this.model = model;
      g = canvas.getGraphicsContext2D();     
   }
   
   // change the background color to the current cell color
   void updateBG() {
      background = currentCellColor();
   }

   private Paint currentCellColor() {
      if (USE_RAINBOW_COLORS) {
         return rainbow[(model.getX() + model.getY() * N) % rainbow.length];
      }
      return rainbow[0];
   }

   // repaint the canvas
   public void draw() {
      g.setFill(background);
      g.fillRect(0, 0, SIZE, SIZE);
      g.setFill(currentCellColor());
      g.fillRect(model.getX()*SIZE/N, model.getY()*SIZE/N, SIZE/N, SIZE/N);
      g.setStroke(Color.WHITE);
      g.setGlobalBlendMode(BlendMode.DIFFERENCE);
      for (int i = 1; i <= 9; i++) {
         g.strokeLine(0, i*SIZE/N, SIZE, i*SIZE/N);
         g.strokeLine(i*SIZE/N, 0, i*SIZE/N, SIZE);
      }
      g.setGlobalBlendMode(BlendMode.SRC_OVER);
   }

}
