package mvc;

import javafx.event.ActionEvent;
import javafx.event.EventHandler;
import javafx.geometry.Point2D;
import javafx.scene.Group;
import javafx.scene.Scene;
import javafx.scene.control.Button;
import javafx.scene.control.Label;
import javafx.scene.input.MouseEvent;
import javafx.scene.layout.HBox;
import javafx.scene.layout.Pane;
import javafx.stage.Stage;


/** The view is the graphical display associated
 * with the user interface. It registers observers
 * with the model so that it is notified when the model
 * changes. It provides hooks so that the controller can
 * learn when the view generates input.
 */
public class View {
	private Stage window;
	private Button button;
	private Label label;
	
	View(Observable<Integer> observed, Stage s) {
		window = s;
		button = new Button("Push me");
		Group g = new Group();
		final Pane pan = new HBox();	
		
		g.getChildren().add(pan);
		Scene sc = new Scene(g);
		window.setScene(sc);
		label = new Label("Count: 0");
		window.setOnCloseRequest(null);
		window.setWidth(300);
		window.setHeight(300);
		pan.getChildren().add(button);
		pan.getChildren().add(label);
		
		observed.registerObserver(new Observer<Integer>() {
			public void notify(Integer i) {
				label.setText("Count: " + i);
			}
		});

		// Since this mouse motion input is handled completely within the UI,
		// we just keep it in the view. An alternative would be to
		// put it in the controller.
		pan.setOnMouseEntered(new EventHandler<MouseEvent>() {
			@Override
			public void handle(MouseEvent e) {
				button.setDisable(false);
			}
		});
		
		pan.setOnMouseExited(new EventHandler<MouseEvent>() {
			@Override
			public void handle(MouseEvent e) {
				Point2D p = new Point2D(e.getX(), e.getY());
				if (!pan.getLayoutBounds().contains(p)) {
					button.setDisable(true);
				}
			}
		});
	}

	public void setOnAction(EventHandler<ActionEvent> a) {
		button.setOnAction(a);
	}

	public void start() {
		window.show();
	}
}
