package mvc;

import java.util.Collection;
import java.util.LinkedList;

public class Observable<T> {
	private Collection<Observer<T>> observers = new LinkedList<Observer<T>>();

	public void registerObserver(Observer<T> obs) {
		observers.add(obs);
	}
	
	protected void notifyAll(T event) {
		for (Observer<T> o : observers)
			o.notify(event);
	}
}
