package mvc;

/** This is the data model for the application. It contains
 * no references to GUI classes, so can be reused across multiple UIs.
 * 
 * Because it extends {@code Observable<Integer>}, views interested in
 * displaying the the model state can register {@code Observers} to be
 * notified when the state changes.
 */
public class Counter extends Observable<Integer> {
	private int value = 0;
	
	void increment() {
		value++;
		notifyAll(value);
	}
	int currentValue() {
		return value;
	}
}
