import java.io.IOException;
import java.net.URI;
import java.net.http.HttpClient;
import java.net.http.HttpRequest;
import java.net.http.HttpRequest.BodyPublishers;
import java.net.http.HttpResponse;
import java.net.http.HttpResponse.BodyHandlers;

/**
 * HTTP Client demo program. Can either GET or POST to a URL and read input back
 * from the server.
 */
public class Client {

	public static void main(String[] args) {
		try {
			sendGet("http://localhost:8080/");
		} catch (IOException | InterruptedException e) {
			e.printStackTrace();
		}
	}

	public static void sendGet(String url) throws IOException, InterruptedException {
		HttpClient client = HttpClient.newHttpClient();
		HttpRequest request = HttpRequest.newBuilder().uri(URI.create(url)).build();
		HttpResponse<String> response = client.send(request, BodyHandlers.ofString());

		System.out.println("Status Code: " + response.statusCode());
		System.out.println("Response Body: " + response.body());
	}

	public static void sendPost(String url, String body) throws IOException, InterruptedException {
		HttpClient client = HttpClient.newHttpClient();
		HttpRequest request = HttpRequest.newBuilder().POST(BodyPublishers.ofString(body)).uri(URI.create(url)).build();
		HttpResponse<String> response = client.send(request, BodyHandlers.ofString());

		System.out.println("Status Code: " + response.statusCode());
		System.out.println("Response Body: " + response.body());
	}

}
