/*
 * Decompiled with CFR 0.152.
 */
package cms.util.maybe;

import cms.util.maybe.Maybe;
import cms.util.maybe.NoMaybeValue;
import java.util.Iterator;
import java.util.NoSuchElementException;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.function.Supplier;

class Maybes {
    private static final None theNone = new None();

    Maybes() {
    }

    static <T> Maybe<T> none() {
        return theNone;
    }

    static <T> Maybe<T> some(T t) {
        if (t == null) {
            throw new IllegalArgumentException("Maybe.some() requires a non-null argument");
        }
        return new Some<T>(t);
    }

    private static class Some<T>
    extends Maybe<T> {
        private T value;

        Some(T t) {
            this.value = t;
        }

        @Override
        public boolean isPresent() {
            return true;
        }

        @Override
        public T get() throws NoMaybeValue {
            return this.value;
        }

        @Override
        public T orElse(T t) {
            return this.value;
        }

        @Override
        public T orElseGet(Supplier<T> supplier) {
            return this.value;
        }

        @Override
        public <U> Maybe<U> thenMaybe(Function<T, Maybe<U>> function) {
            return function.apply(this.value);
        }

        @Override
        public <U> Maybe<U> then(Function<T, U> function) {
            return Maybes.some(function.apply(this.value));
        }

        @Override
        public void thenDo(Consumer<T> consumer) {
            consumer.accept(this.value);
        }

        @Override
        public Iterator<T> iterator() {
            return new Iterator<T>(){
                boolean yielded = false;

                @Override
                public T next() {
                    if (this.yielded) {
                        throw new NoSuchElementException();
                    }
                    this.yielded = true;
                    return value;
                }

                @Override
                public boolean hasNext() {
                    return !this.yielded;
                }
            };
        }

        @Override
        public Maybe<T> orElseMaybe(Supplier<Maybe<T>> supplier) {
            return this;
        }

        public String toString() {
            return this.value.toString();
        }

        public boolean equals(Object object) {
            return object instanceof Some && this.value.equals(((Some)object).value);
        }

        public int hashCode() {
            return this.value.hashCode();
        }
    }

    private static class None<T>
    extends Maybe<T> {
        private None() {
        }

        @Override
        public boolean isPresent() {
            return false;
        }

        @Override
        public T get() throws NoMaybeValue {
            throw NoMaybeValue.theException;
        }

        @Override
        public T orElse(T t) {
            return t;
        }

        @Override
        public T orElseGet(Supplier<T> supplier) {
            return supplier.get();
        }

        @Override
        public <U> Maybe<U> thenMaybe(Function<T, Maybe<U>> function) {
            return Maybe.none();
        }

        @Override
        public <U> Maybe<U> then(Function<T, U> function) {
            return Maybe.none();
        }

        @Override
        public void thenDo(Consumer<T> consumer) {
        }

        @Override
        public Iterator<T> iterator() {
            return new Iterator<T>(){

                @Override
                public T next() {
                    throw new NoSuchElementException();
                }

                @Override
                public boolean hasNext() {
                    return false;
                }
            };
        }

        @Override
        public Maybe<T> orElseMaybe(Supplier<Maybe<T>> supplier) {
            return supplier.get();
        }

        public String toString() {
            return "none";
        }

        public boolean equals(Object object) {
            return object == this;
        }

        public int hashCode() {
            return 0;
        }
    }
}

