/*
 * Decompiled with CFR 0.152.
 */
package cms.util.maybe;

import cms.util.maybe.Maybes;
import cms.util.maybe.NoMaybeValue;
import java.util.Iterator;
import java.util.Optional;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.function.Supplier;

public abstract class Maybe<T>
implements Iterable<T> {
    public abstract boolean isPresent();

    public abstract T get() throws NoMaybeValue;

    public abstract <U> Maybe<U> thenMaybe(Function<T, Maybe<U>> var1);

    public abstract <U> Maybe<U> then(Function<T, U> var1);

    public abstract T orElse(T var1);

    public abstract T orElseGet(Supplier<T> var1);

    public abstract Maybe<T> orElseMaybe(Supplier<Maybe<T>> var1);

    public abstract void thenDo(Consumer<T> var1);

    @Override
    public abstract Iterator<T> iterator();

    public static <T> Maybe<T> from(T t) {
        return t == null ? Maybe.none() : Maybe.some(t);
    }

    public static <T> Maybe<T> fromOptional(Optional<T> optional) {
        return optional.map(Maybe::some).orElseGet(Maybe::none);
    }

    public Optional<T> toOptional() {
        return this.then(Optional::of).orElse(Optional.empty());
    }

    public static <T> T getOptional(Optional<T> optional) throws NoMaybeValue {
        if (optional.isPresent()) {
            return optional.get();
        }
        throw NoMaybeValue.theException;
    }

    public static <T> Maybe<T> none() {
        return Maybes.none();
    }

    public static <T> Maybe<T> some(T t) {
        return Maybes.some(t);
    }

    public static <T, U extends T> Maybe<T> cast(Maybe<U> maybe) {
        return maybe;
    }
}

