package fxml;

import java.io.IOException;
import java.net.URL;
import java.util.ResourceBundle;

import javafx.application.Application;
import javafx.event.ActionEvent;
import javafx.fxml.FXML;
import javafx.fxml.FXMLLoader;
import javafx.fxml.Initializable;
import javafx.scene.Parent;
import javafx.scene.Scene;
import javafx.scene.control.Button;
import javafx.scene.control.Label;
import javafx.stage.Stage;
import model.TicTacToe;

// a small example of reading a scene layout from an XML file instead of
// creating all the objects.
public class Main extends Application implements Initializable {
	@FXML
	private Button b00;
	@FXML
	private Button b01;
	@FXML
	private Button b02;
	@FXML
	private Button b10;
	@FXML
	private Button b11;
	@FXML
	private Button b12;
	@FXML
	private Button b20;
	@FXML
	private Button b21;
	@FXML
	private Button b22;
	@FXML
	private Label t;

	/**
	 * Game object (the model, in the MVC pattern)
	 */
	private TicTacToe game;

	public static void main(final String[] args) {
		Application.launch(args);
	}

	@Override
	public void start(final Stage stage) {
		try {
			final URL r = getClass().getResource("tictactoe.fxml");
			if (r == null) {
				System.err.println("No FXML resource found.");
				try {
					stop();
				} catch (final Exception e) {
				}
			}
			final Parent node = FXMLLoader.load(r);
			final Scene scene = new Scene(node);
			stage.setTitle(GameStrings.NAME);
			stage.setScene(scene);
			stage.sizeToScene();
			stage.show();

		} catch (final IOException ioe) {
			System.err.println("Can't load FXML file.");
			ioe.printStackTrace();
			try {
				stop();
			} catch (final Exception e) {
			}
		}

	}

	@FXML
	private void handleButtonPressed(final ActionEvent ae) {
		int x = 0;
		int y = 0;

		Button btn = (Button) ae.getSource();
		if (btn == b01 || btn == b11 || btn == b21) {
			x = 1;
		} else if (btn == b02 || btn == b12 || btn == b22) {
			x = 2;
		}
		if (btn == b10 || btn == b11 || btn == b12) {
			y = 1;
		} else if (btn == b20 || btn == b21 || btn == b22) {
			y = 2;
		}

		boolean isXTurn = game.currentStatus() == TicTacToe.GameStatus.X_TURN;
		if (game.move(x, y)) {
			btn.setText(isXTurn ? GameStrings.X : GameStrings.O);
			t.setText(isXTurn ? GameStrings.O_MOVE : GameStrings.X_MOVE);
		} else {
			t.setText(GameStrings.ILLEGAL);
		}

		switch (game.currentStatus()) {
		case X_WIN:
			t.setText(GameStrings.X_WIN);
			break;
		case O_WIN:
			t.setText(GameStrings.O_WIN);
			break;
		case TIE:
			t.setText(GameStrings.TIE);
			break;
		default:
			break;
		}

	}

	@FXML
	private void resetGame(ActionEvent ae) {
		game = new TicTacToe();
		for (Button b : new Button[] { b00, b01, b02, b10, b11, b12, b20, b21, b22 }) {
			b.setText("");
		}
		t.setText(GameStrings.START);
	}

	@Override
	public void initialize(final URL location, final ResourceBundle resources) {
		game = new TicTacToe();
		resetGame(null);
	}
}
