package visitor;

import ast.Concat;
import ast.EmptySet;
import ast.EmptyString;
import ast.Plus;
import ast.Star;
import ast.Symbol;

public class SizeVisitor implements RegularExprVisitor<Integer> {

   @Override
   public Integer visit(Symbol s) {
      return 1;
   }

   @Override
   public Integer visit(Star s) {
      return 1 + s.accept(this);
   }

   @Override
   public Integer visit(Plus p) {
      return 1 + p.left.accept(this) + p.right.accept(this);
   }

   @Override
   public Integer visit(Concat c) {
      return 1 + c.left.accept(this) + c.right.accept(this);
   }

   @Override
   public Integer visit(EmptyString e) {
      return 1;
   }

   @Override
   public Integer visit(EmptySet e) {
      return 1;
   }

}
