package visitor;

import ast.Concat;
import ast.EmptySet;
import ast.EmptyString;
import ast.Node;
import ast.Plus;
import ast.Star;
import ast.Symbol;

public class Simplify implements RegularExprVisitor<Node> {

   @Override
   public Node visit(Symbol s) {
      return s;
   }

   @Override
   public Node visit(Star s) {
      Node child = s.child.accept(this);
      if (child instanceof EmptySet) return new EmptyString();
      if (child instanceof EmptyString) return new EmptyString();
      return s;
   }

   @Override
   public Node visit(Plus p) {
      Node left = p.left.accept(this);
      Node right = p.right.accept(this);
      if (left instanceof EmptySet) return right;
      if (right instanceof EmptySet) return left;
      return new Plus(left, right);
   }

   @Override
   public Node visit(Concat c) {
      Node left = c.left.accept(this);
      Node right = c.right.accept(this);
      if (left instanceof EmptySet) return left;
      if (right instanceof EmptySet) return right;
      if (left instanceof EmptyString) return right;
      if (right instanceof EmptyString) return left;
      return new Concat(left, right);
   }

   @Override
   public Node visit(EmptyString e) {
      return e;
   }

   @Override
   public Node visit(EmptySet e) {
      return e;
   }

}
