package visitor;

import ast.Concat;
import ast.EmptySet;
import ast.EmptyString;
import ast.Node;
import ast.Plus;
import ast.Star;
import ast.Symbol;

public class Reverse implements RegularExprVisitor<Node> {

   @Override
   public Node visit(Symbol s) {
      return s;
   }

   @Override
   public Node visit(Star s) {
      return new Star(s.child.accept(this));
   }

   @Override
   public Node visit(Plus p) {
      return new Plus(p.left.accept(this), p.right.accept(this));
   }

   @Override
   public Node visit(Concat c) {
      return new Concat(c.right.accept(this), c.left.accept(this));
   }

   @Override
   public Node visit(EmptyString e) {
      return e;
   }

   @Override
   public Node visit(EmptySet e) {
      return e;
   }

}
