package visitor;

import ast.Concat;
import ast.EmptySet;
import ast.EmptyString;
import ast.Plus;
import ast.Star;
import ast.Symbol;

public class PrettyPrinter implements RegularExprVisitor<String> {

   @Override
   public String visit(Symbol s) {
      return String.valueOf(s.c);
   }

   @Override
   public String visit(Star s) {
      if (s.child instanceof Plus || s.child instanceof Concat)
         return "(" + s.child.accept(this) + ")*";
      return s.child.accept(this) + "*";
   }

   @Override
   public String visit(Plus p) {
      return p.left.accept(this) + " + " + p.right.accept(this);
   }

   @Override
   public String visit(Concat c) {
      String left = c.left.accept(this);
      String right = c.right.accept(this);
      if (c.left instanceof Plus) left = "(" + left + ")";
      if (c.right instanceof Plus) right = "(" + right + ")";
         return left + right;
   }

   @Override
   public String visit(EmptyString e) {
      return "ε";
   }

   @Override
   public String visit(EmptySet e) {
      return "Ø";
   }

}
