package visitor;

import ast.Concat;
import ast.EmptySet;
import ast.EmptyString;
import ast.Plus;
import ast.Star;
import ast.Symbol;
import ast.Node;


public class Derivative implements RegularExprVisitor<Node> {
   final static private AcceptsEmptyString obs = new AcceptsEmptyString();

   final private char x;

   public Derivative(char x) {
      this.x = x;
   }

   public static boolean accepts(Node e, String s) {
      Node current = e;
      for (char c : s.toCharArray()) {
         current = current.accept(new Derivative(c));
      }
      return current.accept(obs);
   }

   @Override
   public Node visit(Symbol s) {
      return s.c == x ? new EmptyString() : new EmptySet();
   }

   @Override
   public Node visit(Star s) {
      return new Concat(s.child.accept(this), s);
   }

   @Override
   public Node visit(Plus p) {
      return new Plus(p.left.accept(this), p.right.accept(this));
   }

   @Override
   public Node visit(Concat c) {
      Node newLeft = new Concat(c.left.accept(this), c.right);
      if (c.left.accept(obs)) {
         return new Plus(newLeft, c.right.accept(this));
      } else {
         return newLeft;
      }
   }

   @Override
   public Node visit(EmptyString e) {
      return new EmptySet();
   }

   @Override
   public Node visit(EmptySet e) {
      return new EmptySet();
   }

}
