package visitor;

import ast.Concat;
import ast.EmptySet;
import ast.EmptyString;
import ast.Plus;
import ast.Star;
import ast.Symbol;

public class AcceptsEmptyString implements RegularExprVisitor<Boolean> {

	@Override
	public Boolean visit(Symbol s) {
		return false;
	}

	@Override
	public Boolean visit(Star s) {
		return true;
	}

	@Override
	public Boolean visit(Plus p) {
		return p.left.accept(this) || p.right.accept(this);
	}

	@Override
	public Boolean visit(Concat c) {
		return c.left.accept(this) && c.left.accept(this);
	}

	@Override
	public Boolean visit(EmptyString e) {
		return true;
	}

	@Override
	public Boolean visit(EmptySet e) {
		return false;
	}

}
