package main;

import ast.Concat;
import ast.Node;
import ast.Plus;
import ast.Star;
import ast.Symbol;
import visitor.Derivative;
import visitor.PrettyPrinter;
import visitor.Reverse;
import visitor.Simplify;

public class Main {
   
   static PrettyPrinter pp = new PrettyPrinter();
   static Derivative deriv0 = new Derivative('o');
   static Derivative deriv1 = new Derivative('i');
   static Reverse rev = new Reverse();
   static Simplify smp = new Simplify();

   public static void main(String[] args) {
      // (0 + 1(01*0)*1)* multiples of 3 in binary
      Star n = new Star(new Plus(new Symbol('o'),
               new Concat(new Concat(new Symbol('i'),
                        new Star(new Concat(new Concat(new Symbol('o'),
                                 new Star(new Symbol('i'))),
                                 new Symbol('o')))),
                        new Symbol('i'))));
      
      System.out.println(pp.visit(n));

      Concat n1 = (Concat)deriv1.visit(n);
      n1 = (Concat)smp.visit(n1);
      System.out.println(pp.visit(n1));

      //divide by 2
      Star k = (Star)rev.visit(n);
      Concat dk0 = (Concat)deriv0.visit(k);
      Concat dk1 = (Concat)deriv1.visit(k);
      Plus p = (Plus)rev.visit(new Plus(dk0, dk1));
      p = (Plus)smp.visit(p);
      System.out.println(pp.visit(p));
   }

}
