package sliderDemo;

import java.net.URL;
import javafx.application.Application;
import javafx.fxml.FXMLLoader;
import javafx.scene.Scene;
import javafx.stage.Stage;

/**
 * Slider demo
 * 
 * The view is specified by the FXML file scene.fxml,
 * which was created by SceneBuilder. The main method loads the
 * view and displays it. This also initializes the controller.
 * The controller is specified in the FXML file (bottom left
 * in SceneBuilder).
 */
public class Main extends Application {

   public static void main(String[] args) {
      launch(args);
   }

   @Override
   public void start(Stage stage) {
      try {
         URL r = getClass().getResource("scene.fxml");
         if (r == null) throw new Exception("No FXML resource found.");
         Scene scene = new Scene(FXMLLoader.load(r));
         stage.setTitle("Slider Demo");
         stage.setScene(scene);
         stage.sizeToScene();
         stage.show();

      } catch (Exception e) {
         System.out.println(e.getMessage());
         e.printStackTrace();
      }
   }

}
