package grid;

import javafx.animation.KeyFrame;
import javafx.animation.Timeline;
import javafx.application.Application;
import javafx.application.Platform;
import javafx.event.ActionEvent;
import javafx.event.EventHandler;
import javafx.scene.Scene;
import javafx.scene.control.Label;
//import javafx.scene.input.MouseEvent;
import javafx.scene.layout.HBox;
import javafx.scene.layout.Pane;
import javafx.scene.layout.VBox;
import javafx.stage.Stage;
import javafx.util.Duration;

public class Main extends Application {
   Grid grid;
   Label locLabel;
   Stage mainWindow;

   public static void main(String[] args) {
      Application.launch(args);
   }

   @Override
   public void start(Stage s) throws Exception {
      mainWindow = s;
      s.setWidth(800);
      s.setHeight(600);
      HBox b = new HBox();
      Scene sc = new Scene(b);
      s.setScene(sc);
      // sc.setOnMouseMoved(new EventHandler<MouseEvent>() {
      // @Override
      // public void handle(MouseEvent e) {
      // System.out.println("Mouse moved" + e.getX() + "," + e.getY());
      // }
      // });
      grid = new Grid(this);
      b.getChildren().add(grid);
      Pane rightSide = new VBox();
      locLabel = new Label("location");
      rightSide.getChildren().add(locLabel);
      reportLocation(0, 0);
      b.getChildren().add(rightSide);
      mainWindow.show();
      grid.draw();
      mainWindow.setOnCloseRequest(null);

      Timeline timeline = new Timeline(new KeyFrame(Duration.millis(100),
               new EventHandler<ActionEvent>() {
                  public void handle(ActionEvent ev) {
                     grid.advanceSelection();
                  }
               }));
      timeline.setCycleCount(Timeline.INDEFINITE);
      timeline.play();
   }

   void startAnimation() {
      Platform.runLater(new Runnable() {
         @Override
         public void run() {
            grid.advanceSelection();
         }
      });
   }

   public void reportLocation(double x, double y) {
      locLabel.setText("(" + (int)x + "," + (int)y + ")");
   }
}
