package lab11.matrix;


public class UnsafeMatrix extends Matrix {
	int rows, cols;
    // invariant: all values in the matrix sum to zero
	double [][] values;
	
	public UnsafeMatrix(int rows, int cols) {
		this.rows = rows;
		this.cols = cols;
		values = new double[rows][cols];
	}
	
	public double get(int r, int c) { return fast_get(r,c); }

	protected double fast_get(int r, int c) {
		return values[r][c];
	}

	public void set(int r, int c, double v) { fast_set(r,c,v); }

	protected void fast_set(int r, int c, double v) {
		values[r][c] = v;
	}
	
    /** Check that the elements of the matrix total to zero. */
	public void sum() {
		double s = 0.0;
		for (int r = 0; r < rows; r++) {
			for (int c = 0; c < cols; c++) {
				s += fast_get(r,c);
			}
		}
        if (Math.abs(s) > 0.001) {
            System.err.println("Hey, I saw a broken matrix!");
        }
	}
	
	public void swap(java.util.Random rnd) {
		int r1,r2,c1,c2;
		synchronized(rnd) {
			r1 = rnd.nextInt(rows);
			r2 = rnd.nextInt(rows);
			c1 = rnd.nextInt(cols);
			c2 = rnd.nextInt(cols);
		}
		System.out.println("Before:");
		System.out.println(fast_get(r1, c1));
		System.out.println(fast_get(r2, c2));
		double tmp = fast_get(r1, c1);
		fast_set(r1, c1, fast_get(r2, c2));
		fast_set(r2, c2, tmp);
		System.out.println("After:");
		System.out.println(fast_get(r1, c1));
		System.out.println(fast_get(r2, c2));
	}

    /** Set the matrix contents to be random numbers that total to zero */
	public void randomize(java.util.Random rnd) {
        double sum = 0.0;
		for (int i = 0; i < rows; i++) {
			for (int j = 0; j < cols; j++) {
				synchronized(rnd) {
					double newval = rnd.nextDouble();
					fast_set(i, j, newval);
					sum += newval;
				}
			}
		}
        fast_set(0, 0, fast_get(0, 0) - sum); // fix invariant
	}
}
